//
//  MCEventTracker+ServerSupport.h
//  MCClientServer
//
//  Created by Brent Gulanowski on 10-02-10.
//  Copyright 2010 Marketcircle Inc. All rights reserved.
//


#import <MCServerSupport/MCEventTracker.h>

#import <MCPostgresPersistence/MCPGServer.h>

#import <MCFoundation/NSFileManager+MCAdditions.h>


@class MCPGServer;

@interface NSFileManager (ServerLogRotating)

- (void)rotateLogAtPath:(NSString *)path ifOlderThanDate:(NSDate *)expiryDate threshold:(int)threshold;

@end


@interface MCEventTracker (ServerSupport)

+ (MCEventTracker *)createEventTrackerWithDatabasePath:(NSString *)path;

+ (NSString *)clientEventsExportLogName;
+ (NSString *)serverEventsExportLogName;

- (NSDate *)eventFlushingCutoffDate;

- (void)flushTrackedEvents;
- (void)archiveTrackedEvents;

@end

